function onBegin()
    disableMovement()
    disableRetry()

    setFlag("BLACKLIGHT_ITB_ENDING_ROSE", false)
    wait(1)

    setFlag("BLACKLIGHT_ITB_ENDING_BARRIER", true)
    jump()
    wait(0.4)
    dash(1, 0)
    wait(0.4)
    walk(16)
    wait(0.4)

    playSprite("duck")
    wait(0.7)
    setFlag("BLACKLIGHT_ITB_ENDING_ROSE", true)
    wait(0.5)
    playSprite("idle", 1)

    walk(-36)
    wait(2.5)
    walk(10)
    wait(0.8)
    playSprite("sitDown")
    wait(2.5)

    say("BLACKLIGHT_ITB_DIALOGUE_ENDING_1")
    wait(1.5)
    say("BLACKLIGHT_ITB_DIALOGUE_ENDING_2")
    wait(3)
    say("BLACKLIGHT_ITB_DIALOGUE_ENDING_3")
    wait(3)
    say("BLACKLIGHT_ITB_DIALOGUE_ENDING_4")
    wait(5)
    say("BLACKLIGHT_ITB_DIALOGUE_ENDING_5")
    playMusic("event:/blacklight/a_full_life")
    wait(152)

    wait(1)
    playSprite("idle", 1)
    wait(1)
    say("BLACKLIGHT_ITB_DIALOGUE_ENDING_6")
    wait(1)
    walk(-268)
    wait(3)
end

function playSprite(sprite, duration)
    player.DummyAutoAnimate = false
    player.Sprite:Play(sprite, false, false)
    if (duration) then
        wait(duration)
        player.DummyAutoAnimate = true
    end
end

function dash(xVector, yVector)
    player.OverrideDashDirection = vector2(xVector, yVector)
    setPlayerState(2)
    wait(0.6)
    setPlayerState(11)
    player.OverrideDashDirection = nil
end

function onEnd(room, wasSkipped)
    setFlag("BLACKLIGHT_ITB_ENDING_BARRIER", true)
    enableMovement()
    enableRetry()
    completeArea(true, false, false)
end